
#include "g_local.h"
#include <io.h>
#include <FCNTL.H>
#include <time.h>
#include <sys/stat.h>



// SJS Gibstat-compatible logging
// Steve Streeting 1998

int logfile;
char writeBuffer[200];


void StartFragLog(void)
{
	char months[12][4] = {"Jan","Feb","Mar","Apr","May","Jun",
						  "Jul","Aug","Sep","Oct","Nov","Dec"};
	char file_name[256];
	cvar_t *game_dir;
	char logtime[15];
	cvar_t *hostname;
	time_t stime;
	struct tm *now;


	if (!fraglog->value)
		return;


	time(&stime);
	now = localtime(&stime);
	
	sprintf(logtime,"%i%s%i_%i%i%i"	,now->tm_mday
									,months[now->tm_mon]
									,now->tm_year
									,now->tm_hour
									,now->tm_min
									,now->tm_sec);
	hostname = gi.cvar("hostname","",0);


	game_dir = gi.cvar ("game", "", 0);
	sprintf(file_name,".\\%s\\%s%s.log",game_dir->string
										,hostname->string
										,logtime);

	gi.dprintf("\nCreating log file %s\n",file_name);

	logfile = _open(file_name,_O_CREAT | _O_TEXT|_O_RDWR ,_S_IWRITE);

	// Write beginning log sections
	// Version
	sprintf(writeBuffer,"\t\tStdLog\t1.2\n");
	_write(logfile,writeBuffer,strlen(writeBuffer));

	// Patch name
	sprintf(writeBuffer,"\t\tPatchName\tDeathmatch Manager\n");
	_write(logfile,writeBuffer,strlen(writeBuffer));
	
	// Log Date
	sprintf(writeBuffer,"\t\tLogDate\t%i.%i.%i\n",now->tm_mday
												,now->tm_mon + 1
												,now->tm_year);
	_write(logfile,writeBuffer,strlen(writeBuffer));

	// Log Time
	sprintf(writeBuffer,"\t\tLogTime\t%i:%i:%i\n",now->tm_hour
												,now->tm_min
												,now->tm_sec);
	_write(logfile,writeBuffer,strlen(writeBuffer));

 

	
}

void LogGameStart(char * mapname)
{
	cvar_t *dmf;


	if (!fraglog->value)
		return;

	//gi.dprintf("\nWriting game start info...\n");

	dmf = gi.cvar ("dmflags","",0);
	
	// Deathmatch Flags
	sprintf(writeBuffer,"\t\tLogDeathFlags\t%s\n",dmf->string);
	_write(logfile,writeBuffer,strlen(writeBuffer));

	// Map Name
	sprintf(writeBuffer,"\t\tMap\t%s\n",mapname);
	_write(logfile,writeBuffer,strlen(writeBuffer));


	// Game Start
	sprintf(writeBuffer,"\t\tGameStart\t\t\t%i\n",(int)level.time);
	_write(logfile,writeBuffer,strlen(writeBuffer));


}	

void LogPlayerDeath(edict_t *self, edict_t *attacker, char *cause)
{
	
	int score;
	char type[10];
	int ping;

	if (!fraglog->value)
		return;



	if (attacker == NULL)
	{
		
		score = -1;
		sprintf(type,"Suicide");
		sprintf(writeBuffer,"%s\t\t%s\t%s\t%i\t%i\t0\n",self->client->pers.netname
												,type
												,cause
												,score
												,(int)level.time);

	}
	else
	{
		score = 1;
		sprintf(type,"Kill");
		sprintf(writeBuffer,"%s\t%s\t%s\t%s\t%i\t%i\t0\n",attacker->client->pers.netname
												,self->client->pers.netname
												,type
												,cause
												,score
												,(int)level.time);
	}

	
	//gi.dprintf("\nWriting player death log: \n%s\n",writeBuffer);
	_write(logfile,writeBuffer,strlen(writeBuffer));

	
}

void LogPlayerConnect(edict_t *player)
{
	char team[20];

	if (!fraglog->value)
		return;
	
	if (ctf->value)
	{
		sprintf(team,"%s",CTFTeamName(player->client->resp.ctf_team));
		// Make end of it lower case
		strncpy(team+1,_strlwr(team+1),strlen(team)-1);
	}
	else
		sprintf(team,"");


	sprintf(writeBuffer,"\t\tPlayerConnect\t%s\t%s\t%i\n",
				player->client->pers.netname,
				team,
				(int)level.time);

	//gi.dprintf("\nWriting connect info:\n%s\n",writeBuffer);
	_write(logfile,writeBuffer,strlen(writeBuffer));
}

void LogPlayerDisconnect(edict_t *player)
{
	if (!fraglog->value)
		return;

	sprintf(writeBuffer,"\t\tPlayerLeft\t%s\t\t%i\n",
				player->client->pers.netname,
				(int)level.time);
	//gi.dprintf("\nWriting disconnect info:\n%s\n",writeBuffer);
	_write(logfile,writeBuffer,strlen(writeBuffer));
}


void LogCTFBonus(edict_t *self, int bonus, char *description)
{
	if (!fraglog->value)
		return;
	
	sprintf(writeBuffer, "%s\t\t%s\t\t%i\t%i\t0\n",
							self->client->pers.netname,	
							description,
							bonus,
							(int)level.time);
	_write(logfile,writeBuffer,strlen(writeBuffer));



}

void LogCTFChangeTeam(edict_t *self,char *teamname)
{
	if (!fraglog->value)
		return;

	// Convert end to lower case
	strncpy(teamname+1,_strlwr(teamname+1),strlen(teamname)-1);

	sprintf(writeBuffer, "\t\tPlayerTeamChange\t%s\t%s\t%i\n",
							self->client->pers.netname,	
							teamname,
							(int)level.time);
	_write(logfile,writeBuffer,strlen(writeBuffer));


}
	
void EndFragLog(void)
{

	//Write ending log sections
	if (!fraglog->value)
		return;

	gi.dprintf("\nClosing log file\n");
	_close(logfile);
}
